/*
Copyright (c) 2009, Michael Kazhdan
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer. Redistributions in binary form must reproduce
the above copyright notice, this list of conditions and the following disclaimer
in the documentation and/or other materials provided with the distribution. 

Neither the name of the Johns Hopkins University nor the names of its contributors
may be used to endorse or promote products derived from this software without specific
prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/
#ifndef MESH_INCLUDED
#define MESH_INCLUDED
#include <vector>
#include "Geometry.h"

template< class Real , class Vertex >
void FitVertices( std::vector< Vertex >& vertices , const Real& scaleFactor , Point3D< Real >& center , Real& scale );

template<class Real , class OrientedVertex>
double SampleOrientedPolygons( const std::vector<OrientedVertex>& vertices , const std::vector<std::vector<int> >& polygons , int sampleNum ,
							   std::vector<OrientedVertex>& samples , bool flatNormal );
template< class Real , class OrientedVertex >
double SampleOrientedPolygons( const std::vector<OrientedVertex>& vertices , const std::vector<std::vector<int> >& polygons , int sampleNum ,
							   std::vector<OrientedVertex>& samples , std::vector<int>& pIndices , bool flatNormal );

template< class Real , class OrientedVertex >
double SampleOrientedTriangles( const std::vector<OrientedVertex>& vertices , const std::vector< TriangleIndex >& triangles , int sampleNum ,
							    std::vector<OrientedVertex>& samples , bool flatNormal );
template< class Real , class OrientedVertex >
double SampleOrientedTriangles( const std::vector<OrientedVertex>& vertices , const std::vector< TriangleIndex >& triangles , int sampleNum ,
							    std::vector<OrientedVertex>& samples , std::vector<int>& pIndices , bool flatNormal );
template< class Real , class Vertex >
double SampleTriangles( const std::vector< Vertex >& vertices , const std::vector< TriangleIndex >& triangles , int sampleNum , std::vector< Point3D< Real > >& samples );
template< class Real , class Vertex >
double SampleTriangles( const std::vector< Vertex >& vertices , const std::vector< TriangleIndex >& triangles , int sampleNum , std::vector< Point3D< Real > >& samples , std::vector< int >& pIndices );
template< class Real , class Vertex >
double SampleTriangles( const std::vector< Vertex >& vertices , const std::vector< TriangleIndex >& triangles , int sampleNum , std::vector< OrientedPoint3D< Real > >& samples );
template< class Real , class Vertex >
double SampleTriangles( const std::vector< Vertex >& vertices , const std::vector< TriangleIndex >& triangles , int sampleNum , std::vector< OrientedPoint3D< Real > >& samples , std::vector< int >& pIndices );


template< class Vertex , class Real >
void SetVertexAreas( std::vector< Vertex >& vertices , const std::vector< std::vector< int> >& polygons , std::vector< Real >& areas );
template< class Vertex , class Real >
void SetVertexAreas( std::vector< Vertex >& vertices , const std::vector< TriangleIndex >& triangles , std::vector< Real >& areas );

template< class Vertex , class Real >
void SetVertexNormals( std::vector< Vertex >& vertices , const std::vector< std::vector< int> >& polygons , std::vector< Point3D< Real > >& normals , bool normalize=true );
template< class Vertex , class Real >
void SetVertexNormals( std::vector< Vertex >& vertices , const std::vector< TriangleIndex >& triangles , std::vector< Point3D< Real > >& normals , bool normalize=true );

template<class OrientedVertex>
void SetVertexNormals( std::vector<OrientedVertex>& vertices , const std::vector< std::vector< int> >& polygons , bool normalize=true );
template<class OrientedVertex>
void SetVertexNormals( std::vector<OrientedVertex>& vertices , const std::vector< TriangleIndex >& triangles , bool normalize=true );


template<class Vertex> void SubdividePolygon( std::vector<Vertex>& vertices , std::vector< std::vector<int> >& polygons );
template<class Vertex> void SubdivideTriangle( std::vector<Vertex>& vertices , std::vector< TriangleIndex >& triangles );
template<class Vertex> void SubdivideTriangle( std::vector<Vertex>& vertices , std::vector< TriangleIndex >& triangles , std::vector< int >& oldIndices );

#include "Mesh.inl"
#endif // MESH_INCLUDED
