#include <stdlib.h>
#include <PNG/png.h>

struct PNGWriteInfo
{
	FILE* fp;
	png_structp png_ptr;
	png_infop info_ptr;
};
struct PNGReadInfo
{
	FILE* fp;
	png_structp png_ptr;
	png_infop info_ptr,end_info;
};

void* PNGInitWrite(char* fileName,int width,int height,int quality)
{
	PNGWriteInfo* info = (PNGWriteInfo*)malloc(sizeof(PNGWriteInfo));
	info->fp = fopen(fileName,"wb");
	if(!info->fp)	fprintf(stderr,"Failed to open: %s\n",fileName)	,	exit(0);

	info->png_ptr = png_create_write_struct(PNG_LIBPNG_VER_STRING,0,0,0);
	if(!info->png_ptr)
	{
		fprintf(stderr,"Failed to create png write struct\n");
		exit(0);
	}
	info->info_ptr = png_create_info_struct(info->png_ptr);
	if(!info->info_ptr)
	{
		fprintf(stderr,"Failed to create png info struct\n");
		exit(0);
	}
	png_init_io(info->png_ptr, info->fp);

	png_set_IHDR(info->png_ptr, info->info_ptr, width, height,
		8,PNG_COLOR_TYPE_RGB,
		PNG_INTERLACE_NONE,
		PNG_COMPRESSION_TYPE_DEFAULT,
		PNG_FILTER_TYPE_DEFAULT);
	png_write_info(info->png_ptr, info->info_ptr);
	return info;
}
void PNGWriteRow(void* pixels,void* v)
{
	unsigned char* _pixels = (unsigned char*)pixels;
	PNGWriteInfo* info = (PNGWriteInfo*)v;
	png_bytep row_pointer=&_pixels[0];
	png_write_row(info->png_ptr, row_pointer);
}
void PNGFinalizeWrite(void* v)
{
	PNGWriteInfo* info = (PNGWriteInfo*)v;
	png_write_end(info->png_ptr, NULL);
	png_destroy_write_struct(&info->png_ptr, &info->info_ptr);
	fclose(info->fp);
	free(info);
}
void* PNGInitRead(char* fileName,int& width,int& height)
{
	PNGReadInfo* info = (PNGReadInfo*)malloc(sizeof(PNGReadInfo));
	info->fp=fopen(fileName,"rb");
	if(!info->fp)	fprintf(stderr,"Failed to open: %s\n",fileName)	,	exit(0);

	info->png_ptr = png_create_read_struct(PNG_LIBPNG_VER_STRING,0,0,0);
	if(!info->png_ptr)
	{
		fprintf(stderr,"Failed to create PNG read structure\n");
		exit(0);
	}
	info->info_ptr = png_create_info_struct(info->png_ptr);
	if(!info->info_ptr)
	{
		fprintf(stderr,"Failed to create PNG info structure 1\n");
		exit(0);
	}
	info->end_info = png_create_info_struct(info->png_ptr);
	if(!info->end_info)	
	{
		fprintf(stderr,"Failed to create PNG info structure 2\n");
		exit(0);
	}
	png_init_io(info->png_ptr, info->fp);
	png_read_info(info->png_ptr, info->info_ptr);
	width=png_get_image_width(info->png_ptr,info->info_ptr);
	height=png_get_image_height(info->png_ptr,info->info_ptr);
	int ncomp=png_get_channels(info->png_ptr,info->info_ptr);
	int bit_depth=png_get_bit_depth(info->png_ptr,info->info_ptr);
	int color_type= png_get_color_type(info->png_ptr,info->info_ptr);
	if(width<=0 || height<=0)				exit(0);
	if(ncomp<1 || ncomp>4)					exit(0);
	if(bit_depth!=8)						exit(0);
	if(color_type==PNG_COLOR_TYPE_PALETTE)	png_set_expand(info->png_ptr)	,	printf("Expanding PNG color pallette\n");
	if (color_type == PNG_COLOR_TYPE_GRAY || color_type == PNG_COLOR_TYPE_GRAY_ALPHA)	png_set_gray_to_rgb(info->png_ptr); // always RGB
	png_set_filler(info->png_ptr, 0, PNG_FILLER_AFTER); // always RGBA
	return info;
}
void PNGReadRow(void* pixels,void* v)
{
	PNGReadInfo* info = (PNGReadInfo*)v;
	png_bytep row=(png_bytep)pixels;
	png_read_row(info->png_ptr,row,NULL);
}

void PNGFinalizeRead(void* v)
{
	PNGReadInfo* info = (PNGReadInfo*)v;
	png_destroy_read_struct(&info->png_ptr, &info->info_ptr, &info->end_info);
	fclose(info->fp);
	free(info);
}
