/*
Copyright (c) 2008, Michael Kazhdan
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer. Redistributions in binary form must reproduce
the above copyright notice, this list of conditions and the following disclaimer
in the documentation and/or other materials provided with the distribution. 

Neither the name of the Johns Hopkins University nor the names of its contributors
may be used to endorse or promote products derived from this software without specific
prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/
#ifndef MULTI_STREAM_IO
#define MULTI_STREAM_IO
#include <vector>
#include "GridStream.h"


class IOStreamState
{
public:
	static const int BYTES_PER_SECTOR;
	static const int IO_BLOCK_SIZE;
	static long long	ReadBytes,WriteBytes;
	enum
	{
		NONE,
		FRONT,
		BACK,
		COMPLETE
	};
	CRITICAL_SECTION lock;
	IOStreamState (void);
	~IOStreamState (void);
	virtual int	Update (void)=0;
};

class RowStreamState : public IOStreamState
{
public:
	int*				off;
	int					blockSize;
	void*				data;
	int					r,rs,win,b;
	HANDLE				hFile;
	bool				read;	// write;
	int					current,front,back;

	RowStreamState(void);
	~RowStreamState(void);
	void	Init	(HANDLE hFile,int rowSize,int rows,int bufferMultiplier);
	void	Reset	(bool read,int minWindowSize);
	void	Unset	(void);
	int		Update	(void);
	bool	Advance	(void);
	void*	operator[]	(int idx);
};
class IOClient
{
public:
	class MultiStreamIOServer* server;
	class IOStreamState* streamState;
	int clientIndex;

	IOClient (void);
	void SetServer (class MultiStreamIOServer* server);
};

class MultiStreamIOServer
{
	HANDLE ioThread;
	static DWORD WINAPI IOThread(LPVOID lpParam);
	std::vector<RowStreamState*> streams;
	std::vector<class MultiStreamIOClient*> clients;
public:
	CRITICAL_SECTION	lock;
	int pendingStream;
	MultiStreamIOServer(void);
	~MultiStreamIOServer(void);

	int AddClient	(MultiStreamIOClient* client);
	void StartIO	(void);
	void WaitOnIO	(void);
	void Reset		(void);
};
class MultiStreamIOClient : public StreamingGrid
{
	friend class MultiStreamIOServer;
	int clientIndex;
	RowStreamState stream;
	HANDLE hFile;
	MultiStreamIOServer* server;
public:
	MultiStreamIOClient	(const char* fileName,int rs,int r,int bufferMultiplier,bool writeOnly=false);
	MultiStreamIOClient	(int rs,int r,int bufferMultiplier);
	MultiStreamIOClient	(int rs,int r,int bufferMultiplier,const char* dir,const char* prefix);
	~MultiStreamIOClient(void);
	void	finalize	(void);
	void	SetServer	(MultiStreamIOServer* manager);

	int		rows		(void) const;
	int		rowSize		(void) const;
	void*	operator[]	(int idx);
	void	advance		(void);
	void	reset		(bool read,int minWindowSize);
	void	unset		(void);
};

#include "MultiStreamIO.inl"
#endif // MULTI_STREAM_IO