/*
Copyright (c) 2008, Michael Kazhdan
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer. Redistributions in binary form must reproduce
the above copyright notice, this list of conditions and the following disclaimer
in the documentation and/or other materials provided with the distribution. 

Neither the name of the Johns Hopkins University nor the names of its contributors
may be used to endorse or promote products derived from this software without specific
prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/
#ifndef IMAGE_STREAM_INCLUDED
#define IMAGE_STREAM_INCLUDED
#include <Half/half.h>
#include "Util/GridStream.h"
#include "Util/Color.h"

extern void*  BMPInitWrite(char* fn,int width,int height,int quality);
extern void*  WDPInitWrite(char* fn,int width,int height,int quality);
extern void* JPEGInitWrite(char* fn,int width,int height,int quality);
extern void*  PNGInitWrite(char* fn,int width,int height,int quality);
extern void*  WDPInitRead(char* fn,int& width,int& height);
extern void* JPEGInitRead(char* fn,int& width,int& height);
extern void*  PNGInitRead(char* fn,int& width,int& height);
extern void  WDPWriteRow(void* pixels,void* info);
extern void  BMPWriteRow(void* pixels,void* info);
extern void JPEGWriteRow(void* pixels,void* info);
extern void  PNGWriteRow(void* pixels,void* info);
extern void  WDPReadRow(void* pixels,void* info);
extern void JPEGReadRow(void* pixels,void* info);
extern void  PNGReadRow(void* pixels,void* info);
extern void  WDPFinalizeWrite(void* info);
extern void  BMPFinalizeWrite(void* info);
extern void JPEGFinalizeWrite(void* info);
extern void  PNGFinalizeWrite(void* info);
extern void  WDPFinalizeRead(void* info);
extern void JPEGFinalizeRead(void* info);
extern void  PNGFinalizeRead(void* info);

template<class Real>	void* InitWrite(char* fn,int width,int height,int quality);
template<class Real>	void* InitRead(char* fn,int& width,int& height);
template<class Real>	void WriteRow(void* pixels,void* info);
template<class Real>	void ReadRow(void* pixels,void* info);
template<class Real>	void FinalizeWrite(void* info);
template<class Real>	void FinalizeRead(void* info);


template<class PReal,class BReal>
class WriteImageStream : public StreamingGrid
{
	void* info;
	PReal* pixels;
	BReal* buffer;

	int current;
	bool _logRGB,_clamp;
	int _q,_w,_h,_cw,_ch;
	void Init(char* fileName);
	double average[3];

	void* (*_InitWrite)		(char*,int,int,int);
	void  (*_WriteRow)		(void*,void*);
	void  (*_FinalizeWrite)	(void*);
public:
	WriteImageStream	(
		void* (*IW)(char*,int,int,int),void (*WR)(void*,void*),void (*FW)(void*),
		char* fileName,int width,int height,int clipWidth,int clipHeight,int quality,bool logRGB,bool clamp
		);
	WriteImageStream	(
		void* (*IW)(char*,int,int,int),void (*WR)(void*,void*),void (*FW)(void*),
		char* fileName,int width,int height,int quality,bool logRGB,bool clamp
		);
	~WriteImageStream	(void);
	int		rows		(void) const;
	int		rowSize		(void) const;
	void*	operator[]	(int idx);
	void	advance		(void);
};

template<class PReal,class BReal>
class ReadImageStream : public StreamingGrid
{
	void* info;
	PReal* pixels;
	BReal* buffer;

	bool _a;
	int current;
	int _w,_h;
	void* (*_InitRead)		(char*,int&,int&);
	void  (*_ReadRow)		(void*,void*);
	void  (*_FinalizeRead)	(void*);
public:
	ReadImageStream	(
		void* (*IR)(char*,int&,int&),void (*RR)(void*,void*),void (*FR)(void*),
		char* fileName,int &width,int &height,bool alpha
		);
	~ReadImageStream	(void);
	int		rows		(void) const;
	int		rowSize		(void) const;
	void*	operator[]	(int idx);
	void	advance		(void);
	bool	hasAlpha	(void)	const;
};

template<class Real,class OutType>
class WImageStream : public WriteImageStream<OutType,Real>
{
public:
	WImageStream		(char* fileName,int width,int height,int clipWidth,int clipHeight,int quality=100,bool logRGB=false);
	WImageStream		(char* fileName,int width,int height,int quality=100,bool logRGB=false);
};
template<class Real>
class BMPWImageStream : public WriteImageStream<unsigned char,Real>
{
public:
	BMPWImageStream		(char* fileName,int width,int height,int clipWidth,int clipHeight,int quality=100,bool logRGB=false);
	BMPWImageStream		(char* fileName,int width,int height,int quality=100,bool logRGB=false);

};
template<class Real>
class JPEGWImageStream : public WriteImageStream<unsigned char,Real>
{
public:
	JPEGWImageStream	(char* fileName,int width,int height,int clipWidth,int clipHeight,int quality=100,bool logRGB=false);
	JPEGWImageStream	(char* fileName,int width,int height,int quality=100,bool logRGB=false);

};
template<class Real>
class PNGWImageStream : public WriteImageStream<unsigned char,Real>
{
public:
	PNGWImageStream		(char* fileName,int width,int height,int clipWidth,int clipHeight,int quality=100,bool logRGB=false);
	PNGWImageStream		(char* fileName,int width,int height,int quality=100,bool logRGB=false);

};
template<class Real>
class WDPWImageStream : public WriteImageStream<half,Real>
{
public:
	WDPWImageStream		(char* fileName,int width,int height,int clipWidth,int clipHeight,int quality=100,bool logRGB=false);
	WDPWImageStream		(char* fileName,int width,int height,int quality=100,bool logRGB=false);
};

template<class Real,class InType>
class RImageStream : public ReadImageStream<InType,Real>
{
public:
	RImageStream	(char* fileName,int &width,int &height);
};
template<class Real>
class JPEGRImageStream : public ReadImageStream<unsigned char,Real>
{
public:
	JPEGRImageStream	(char* fileName,int &width,int &height);
};
template<class Real>
class PNGRImageStream : public ReadImageStream<unsigned char,Real>
{
public:
	PNGRImageStream	(char* fileName,int &width,int &height);
};
template<class Real>
class WDPRImageStream : public ReadImageStream<half,Real>
{
public:
	WDPRImageStream	(char* fileName,int &width,int &height);
};

template<class Real>
class StreamingInputTile
{
	StreamingGrid* data;
	int w,h,rc;
	int sX,sY;
	char tileName[1024];
	Real** rows;
	bool alpha;
public:
	StreamingInputTile(void);
	~StreamingInputTile(void);

	void Init(const char* tName,int rowCount=1,int startX=0,int startY=0);
	void init(int idx);
	Color<Real> operator() (int i,int j);
	Color<Real> operator() (int i,int j,Real& a);
	int width(void) const;
	int height(void) const;
	int startX(void) const;
	int startY(void) const;
	bool hasAlpha(void)	const;
};

template<class Real>
StreamingGrid* GetReadStream(char* fileName,int& width,int& height);
template<class Real>
StreamingGrid* GetReadStream(char* fileName,int& width,int& height,bool& hasAlpha);
template<class Real>
StreamingGrid* GetWriteStream(char* fileName,const int& width,const int& height,const int& quality=100);

#include "Stream.inl"
#include "ImageStream.inl"
#endif // GRID_STREAM_INCLUDED