/*
Copyright (c) 2008, Michael Kazhdan
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer. Redistributions in binary form must reproduce
the above copyright notice, this list of conditions and the following disclaimer
in the documentation and/or other materials provided with the distribution. 

Neither the name of the Johns Hopkins University nor the names of its contributors
may be used to endorse or promote products derived from this software without specific
prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/
#ifndef GRID_STREAM_INCLUDED
#define GRID_STREAM_INCLUDED

#define ASSERT_MEMORY_ACCESS 1

class StreamingGrid
{
public:
	virtual			~StreamingGrid	(void)										{;}
	virtual int		rows			(void) const								= 0;
	virtual int		rowSize			(void) const								= 0;
	virtual void*	operator[]		(int idx)									= 0;
	virtual void	advance			(void)										{;}
	virtual void	reset			(bool read,int minWindowSize)				{;}
	virtual void	unset			(void)										{;}
	virtual void	SetServer		(class MultiStreamIOServer* server)			{;}
};
class BufferedStreamingGrid : public StreamingGrid
{
	bool read;
	void* data;
	int current,win;
	StreamingGrid* sg;
public:
	BufferedStreamingGrid	(StreamingGrid* sg);
	~BufferedStreamingGrid	(void);
	int		rows			(void) const;
	int		rowSize			(void) const;
	void*	operator[]		(int idx);
	void	advance			(void);
	void	reset			(bool read,int minWindowSize);
};

class MemoryBackedGrid : public StreamingGrid
{
	void*	_data;
	int		_r,_rs;
	bool	_del;
public:
	MemoryBackedGrid	(void* data,int rowSize,int rows);
	MemoryBackedGrid	(int rowSize,int rows);
	~MemoryBackedGrid	(void);
	int		rows		(void) const;
	int		rowSize		(void) const;
	void*	operator[]	(int idx);
};
#include "GridStream.inl"
#endif // GRID_STREAM_INCLUDED