/*
Copyright (c) 2008, Michael Kazhdan
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer. Redistributions in binary form must reproduce
the above copyright notice, this list of conditions and the following disclaimer
in the documentation and/or other materials provided with the distribution. 

Neither the name of the Johns Hopkins University nor the names of its contributors
may be used to endorse or promote products derived from this software without specific
prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/
#define ScaledSum128(x1,x2,x3,x4) (_mm_add_ps(_mm_mul_ps(x1,x2),_mm_mul_ps(x3,x4)))

template<class Real,int Type,int Degree,int Channels>
inline void StreamingSolver<Real,Type,Degree,Channels>::SetInteriorDotSum(const __m128 matrixValues[],const __m128* xPtrs[],size_t j,__m128& dotSum) const
{
	dotSum=						_mm_mul_ps(xPtrs[0][j],matrixValues[0]);
	dotSum=_mm_add_ps(dotSum,	_mm_mul_ps(xPtrs[1][j],matrixValues[1]));
	dotSum=_mm_add_ps(dotSum,	_mm_mul_ps(xPtrs[2][j],matrixValues[2]));
}
template<class Real,int Type,int Degree,int Channels>
inline void StreamingSolver<Real,Type,Degree,Channels>::SetDotSum(const __m128 matrixValues[],const __m128* xPtrs[],size_t j,__m128& dotSum) const
{
	dotSum=										_mm_mul_ps(xPtrs[2][j],matrixValues[2]) ;
	if(xPtrs[0])	dotSum=_mm_add_ps(dotSum,	_mm_mul_ps(xPtrs[0][j],matrixValues[0]));
	if(xPtrs[1])	dotSum=_mm_add_ps(dotSum,	_mm_mul_ps(xPtrs[1][j],matrixValues[1]));
	if(xPtrs[3])	dotSum=_mm_add_ps(dotSum,	_mm_mul_ps(xPtrs[3][j],matrixValues[3]));
	if(xPtrs[4])	dotSum=_mm_add_ps(dotSum,	_mm_mul_ps(xPtrs[4][j],matrixValues[4]));
}
template<class Real,int Type,int Degree,int Channels>
inline float StreamingSolver<Real,Type,Degree,Channels>::InteriorGaussSeidelUpdate0(const __m128 mValues[],const __m128* xPtrs[],float& previousDotSum,int j) const
{
	__declspec (align(16)) float scratch[4];
	__m128 dotSum;
	SetInteriorDotSum(mValues,xPtrs,j>>2,dotSum);
	_mm_store_ps(scratch,dotSum);
	scratch[0]=scratch[0]+scratch[1]+scratch[2]+previousDotSum;
	previousDotSum=scratch[2]+scratch[3];
	return (localBPtr[j]-scratch[0]);
}
template<class Real,int Type,int Degree,int Channels>
inline float StreamingSolver<Real,Type,Degree,Channels>::InteriorGaussSeidelUpdate1(const __m128 mValues[],const __m128* xPtrs[],float& previousDotSum,int j) const
{
	__declspec (align(16)) float scratch[4];
	__m128 dotSum;
	SetInteriorDotSum(mValues,xPtrs,j>>2,dotSum);
	_mm_store_ps(scratch,dotSum);
	scratch[0]=(scratch[0]+scratch[1])+(scratch[2]+scratch[3])+previousDotSum;
	previousDotSum=scratch[3];
	return (localBPtr[j]-scratch[0]);
}
template<class Real,int Type,int Degree,int Channels>
inline float StreamingSolver<Real,Type,Degree,Channels>::InteriorGaussSeidelUpdate2(const __m128 mValues[],const __m128* xPtrs[],float& previousDotSum,int j) const
{
	__declspec (align(16)) float scratch[4];
	__m128 dotSum;
	SetInteriorDotSum(mValues,xPtrs,(j>>2)+1,dotSum);
	_mm_store_ps(scratch,dotSum);
	float temp=(previousDotSum+scratch[0]);
	previousDotSum=(scratch[0]+scratch[1])+(scratch[2]+scratch[3]);
	return (localBPtr[j]-temp);
}
template<class Real,int Type,int Degree,int Channels>
inline float StreamingSolver<Real,Type,Degree,Channels>::InteriorGaussSeidelUpdate3(const __m128 mValues[],const __m128* xPtrs[],float& previousDotSum,int j) const
{
	__declspec (align(16)) float scratch[4];
	__m128 dotSum;
	SetInteriorDotSum(mValues,xPtrs,(j>>2)+1,dotSum);
	_mm_store_ps(scratch,dotSum);
	scratch[0]=scratch[0]+scratch[1]+previousDotSum;
	previousDotSum=scratch[1]+scratch[2]+scratch[3];
	return (localBPtr[j]-scratch[0]);
}
template<class Real,int Type,int Degree,int Channels>
inline float StreamingSolver<Real,Type,Degree,Channels>::GetInteriorLaplacianValue0(const __m128 mValues[],const __m128* xPtrs[],float& previousDotSum,int j) const
{
	__declspec (align(16)) float scratch[4];
	__m128 dotSum;
	SetInteriorDotSum(mValues,xPtrs,j>>2,dotSum);
	_mm_store_ps(scratch,dotSum);
	scratch[0]=scratch[0]+scratch[1]+scratch[2]+previousDotSum;
	previousDotSum=scratch[2]+scratch[3];
	return scratch[0];
}
template<class Real,int Type,int Degree,int Channels>
inline float StreamingSolver<Real,Type,Degree,Channels>::GetInteriorLaplacianValue1(const __m128 mValues[],const __m128* xPtrs[],float& previousDotSum,int j) const
{
	__declspec (align(16)) float scratch[4];
	__m128 dotSum;
	SetInteriorDotSum(mValues,xPtrs,j>>2,dotSum);
	_mm_store_ps(scratch,dotSum);
	scratch[0]=scratch[0]+scratch[1]+scratch[2]+scratch[3]+previousDotSum;
	previousDotSum=scratch[3];
	return scratch[0];
}
template<class Real,int Type,int Degree,int Channels>
inline float StreamingSolver<Real,Type,Degree,Channels>::GetInteriorLaplacianValue2(const __m128 mValues[],const __m128* xPtrs[],float& previousDotSum,int j) const
{
	__declspec (align(16)) float scratch[4];
	__m128 dotSum;
	float temp;
	SetInteriorDotSum(mValues,xPtrs,(j>>2)+1,dotSum);
	_mm_store_ps(scratch,dotSum);
	temp=(previousDotSum+scratch[0]);
	previousDotSum=(scratch[0]+scratch[1])+(scratch[2]+scratch[3]);
	return temp;
}
template<class Real,int Type,int Degree,int Channels>
inline float StreamingSolver<Real,Type,Degree,Channels>::GetInteriorLaplacianValue3(const __m128 mValues[],const __m128* xPtrs[],float& previousDotSum,int j) const
{
	__declspec (align(16)) float scratch[4];
	__m128 dotSum;
	SetInteriorDotSum(mValues,xPtrs,(j>>2)+1,dotSum);
	_mm_store_ps(scratch,dotSum);
	scratch[0]=scratch[0]+scratch[1]+previousDotSum;
	previousDotSum=scratch[1]+scratch[2]+scratch[3];
	return scratch[0];
}
template<class Real,int Type,int Degree,int Channels>
inline float StreamingSolver<Real,Type,Degree,Channels>::GetLaplacianValue0(const __m128 mValues[],const WordClass* xPtrs[],float& previousDotSum,int j) const
{
	__declspec (align(16)) float scratch[4];
	__m128 dotSum;
	SetDotSum(mValues,xPtrs,j>>2,dotSum);
	_mm_store_ps(scratch,dotSum);
	scratch[0]=scratch[0]+scratch[1]+scratch[2]+previousDotSum;
	previousDotSum=scratch[2]+scratch[3];
	return scratch[0];
}
template<class Real,int Type,int Degree,int Channels>
inline float StreamingSolver<Real,Type,Degree,Channels>::GetLaplacianValue1(const __m128 mValues[],const WordClass* xPtrs[],float& previousDotSum,int j) const
{
	__declspec (align(16)) float scratch[4];
	__m128 dotSum;
	SetDotSum(mValues,xPtrs,j>>2,dotSum);
	_mm_store_ps(scratch,dotSum);
	scratch[0]=scratch[0]+scratch[1]+scratch[2]+scratch[3]+previousDotSum;
	previousDotSum=scratch[3];
	return scratch[0];
}

template<class Real,int Type,int Degree,int Channels>
inline float StreamingSolver<Real,Type,Degree,Channels>::GetLaplacianValue2(const __m128 mValues[],const WordClass* xPtrs[],float& previousDotSum,int j) const
{
	__declspec (align(16)) float scratch[4];
	__m128 dotSum;
	float temp;
	SetDotSum(mValues,xPtrs,(j>>2)+1,dotSum);
	_mm_store_ps(scratch,dotSum);
	temp=(previousDotSum+scratch[0]);
	previousDotSum=(scratch[0]+scratch[1])+(scratch[2]+scratch[3]);
	return temp;
}
template<class Real,int Type,int Degree,int Channels>
inline float StreamingSolver<Real,Type,Degree,Channels>::GetLaplacianValue3(const __m128 mValues[],const WordClass* xPtrs[],float& previousDotSum,int j) const
{
	__declspec (align(16)) float scratch[4];
	__m128 dotSum;
	float temp;
	SetDotSum(mValues,xPtrs,(j>>2)+1,dotSum);
	_mm_store_ps(scratch,dotSum);
	scratch[0]=scratch[0]+scratch[1]+previousDotSum;
	previousDotSum=scratch[1]+scratch[2]+scratch[3];
	return scratch[0];
}


template<class Real,int Type,int Degree,int Channels>
inline float StreamingSolver<Real,Type,Degree,Channels>::GaussSeidelUpdate0(const __m128 mValues[],const WordClass* xPtrs[],float& previousDotSum,int j) const
{
	__declspec (align(16)) float scratch[4];
	__m128 dotSum;
	SetDotSum(mValues,xPtrs,j>>2,dotSum);
	_mm_store_ps(scratch,dotSum);
	scratch[0]=(scratch[0]+scratch[1])+(scratch[2]+previousDotSum);
	previousDotSum=scratch[2]+scratch[3];
	return (localBPtr[j]-scratch[0]);
}
template<class Real,int Type,int Degree,int Channels>
inline float StreamingSolver<Real,Type,Degree,Channels>::GaussSeidelUpdate1(const __m128 mValues[],const WordClass* xPtrs[],float& previousDotSum,int j) const
{
	__declspec (align(16)) float scratch[4];
	__m128 dotSum;
	SetDotSum(mValues,xPtrs,j>>2,dotSum);
	_mm_store_ps(scratch,dotSum);
	scratch[0]=scratch[0]+scratch[1]+scratch[2]+scratch[3]+previousDotSum;
	previousDotSum=scratch[3];
	return (localBPtr[j]-scratch[0]);
}
template<class Real,int Type,int Degree,int Channels>
inline float StreamingSolver<Real,Type,Degree,Channels>::GaussSeidelUpdate2(const __m128 mValues[],const WordClass* xPtrs[],float& previousDotSum,int j) const
{
	__declspec (align(16)) float scratch[4];
	__m128 dotSum;
	SetDotSum(mValues,xPtrs,(j>>2)+1,dotSum);
	_mm_store_ps(scratch,dotSum);
	float temp=(previousDotSum+scratch[0]);
	previousDotSum=(scratch[0]+scratch[1])+(scratch[2]+scratch[3]);
	return (localBPtr[j]-temp);
}
template<class Real,int Type,int Degree,int Channels>
inline float StreamingSolver<Real,Type,Degree,Channels>::GaussSeidelUpdate3(const __m128 mValues[],const WordClass* xPtrs[],float& previousDotSum,int j) const
{
	__declspec (align(16)) float scratch[4];
	__m128 dotSum;
	SetDotSum(mValues,xPtrs,(j>>2)+1,dotSum);
	_mm_store_ps(scratch,dotSum);
	scratch[0]=scratch[0]+scratch[1]+previousDotSum;
	previousDotSum=scratch[1]+scratch[2]+scratch[3];
	return (localBPtr[j]-scratch[0]);
}
template<class Real,int Type,int Degree,int Channels,class StorageType>
inline void MultiGridStreamingSolver<Real,Type,Degree,Channels,StorageType>::SetInteriorRestrictionDotSum(const __m128 matrixValues[],const __m128* rPtrs[],size_t j,__m128& dotSum) const
{
	dotSum=						_mm_mul_ps(rPtrs[0][j],matrixValues[0]) ;
	dotSum=_mm_add_ps(dotSum,	_mm_mul_ps(rPtrs[1][j],matrixValues[1]));
}
template<class Real,int Type,int Degree,int Channels,class StorageType>
inline float MultiGridStreamingSolver<Real,Type,Degree,Channels,StorageType>::InteriorRestrictionUpdate0(const __m128 mValues[],const __m128* rPtrs[],float& previousDotSum,int j)
{
	__declspec (align(16)) float scratch[4];
	__m128 dotSum;
	SetInteriorRestrictionDotSum(mValues,rPtrs,j>>1,dotSum);
	_mm_store_ps(scratch,dotSum);
	scratch[0]=scratch[0]+scratch[1]+scratch[2]+previousDotSum;
	previousDotSum=scratch[3];
	return scratch[0];
}
template<class Real,int Type,int Degree,int Channels,class StorageType>
inline float MultiGridStreamingSolver<Real,Type,Degree,Channels,StorageType>::InteriorRestrictionUpdate1(const __m128 mValues[],const __m128* rPtrs[],float& previousDotSum,int j)
{
	__declspec (align(16)) float scratch[4];
	__m128 dotSum;
	SetInteriorRestrictionDotSum(mValues,rPtrs,(j>>1)+1,dotSum);
	_mm_store_ps(scratch,dotSum);
	float temp=(previousDotSum+scratch[0]);
	previousDotSum=scratch[1]+scratch[2]+scratch[3];
	return temp;
}
template<class Real,int Type,int Degree,int Channels,class StorageType>
inline void MultiGridStreamingSolver<Real,Type,Degree,Channels,StorageType>::SetRestrictionDotSum(const __m128& matrixValues,const __m128* rPtrs,size_t j,__m128& dotSum) const
{
	dotSum=_mm_mul_ps(rPtrs[j],matrixValues) ;
}
template<class Real,int Type,int Degree,int Channels,class StorageType>
inline float MultiGridStreamingSolver<Real,Type,Degree,Channels,StorageType>::RestrictionUpdate0(const __m128& mValues,const __m128* rPtrs,float& previousDotSum,int j)
{
	__declspec (align(16)) float scratch[4];
	__m128 dotSum;
	SetRestrictionDotSum(mValues,rPtrs,j>>1,dotSum);
	_mm_store_ps(scratch,dotSum);
	scratch[0]=scratch[0]+scratch[1]+scratch[2]+previousDotSum;
	previousDotSum=scratch[3];
	return scratch[0];
}
template<class Real,int Type,int Degree,int Channels,class StorageType>
inline float MultiGridStreamingSolver<Real,Type,Degree,Channels,StorageType>::RestrictionUpdate1(const __m128& mValues,const __m128* rPtrs,float& previousDotSum,int j)
{
	__declspec (align(16)) float scratch[4];
	__m128 dotSum;
	SetRestrictionDotSum(mValues,rPtrs,(j>>1)+1,dotSum);
	_mm_store_ps(scratch,dotSum);
	float temp=(previousDotSum+scratch[0]);
	previousDotSum=scratch[1]+scratch[2]+scratch[3];
	return temp;
}
template<class Real,int Type,int Degree,int Channels,class StorageType>
inline void MultiGridStreamingSolver<Real,Type,Degree,Channels,StorageType>::SetRestrictionDotSum(const __m128 matrixValues[],const __m128* rPtrs[],size_t j,__m128& dotSum) const
{
	dotSum=										_mm_mul_ps(rPtrs[2][j],matrixValues[2]) ;
	if(rPtrs[0])	dotSum=_mm_add_ps(dotSum,	_mm_mul_ps(rPtrs[0][j],matrixValues[0]));
	if(rPtrs[1])	dotSum=_mm_add_ps(dotSum,	_mm_mul_ps(rPtrs[1][j],matrixValues[1]));
	if(rPtrs[3])	dotSum=_mm_add_ps(dotSum,	_mm_mul_ps(rPtrs[3][j],matrixValues[3]));
}
template<class Real,int Type,int Degree,int Channels,class StorageType>
inline float MultiGridStreamingSolver<Real,Type,Degree,Channels,StorageType>::RestrictionUpdate0(const __m128 mValues[],const __m128* rPtrs[],float& previousDotSum,int j)
{
	__declspec (align(16)) float scratch[4];
	__m128 dotSum;
	SetRestrictionDotSum(mValues,rPtrs,j>>1,dotSum);
	_mm_store_ps(scratch,dotSum);
	scratch[0]=scratch[0]+scratch[1]+scratch[2]+previousDotSum;
	previousDotSum=scratch[3];
	return scratch[0];
}
template<class Real,int Type,int Degree,int Channels,class StorageType>
inline float MultiGridStreamingSolver<Real,Type,Degree,Channels,StorageType>::RestrictionUpdate1(const __m128 mValues[],const __m128* rPtrs[],float& previousDotSum,int j)
{
	__declspec (align(16)) float scratch[4];
	__m128 dotSum;
	SetRestrictionDotSum(mValues,rPtrs,(j>>1)+1,dotSum);
	_mm_store_ps(scratch,dotSum);
	float temp=(previousDotSum+scratch[0]);
	previousDotSum=scratch[1]+scratch[2]+scratch[3];
	return temp;
}
