/*
Copyright (c) 2011, Michael Kazhdan and Ming Chuang
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer. Redistributions in binary form must reproduce
the above copyright notice, this list of conditions and the following disclaimer
in the documentation and/or other materials provided with the distribution. 

Neither the name of the Johns Hopkins University nor the names of its contributors
may be used to endorse or promote products derived from this software without specific
prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/
#ifndef SPLINE_INCLUDED
#define SPLINE_INCLUDED

template< class Real >
class Spline
{
public:
	enum
	{
		NEAREST ,
		LINEAR ,
		QUADRATIC ,
		CUBIC ,
		CATMULL_ROM ,
		CUBIC_B_SPLINE
	};

	static void   Weights( Real t , Real &w1 , Real& w2 , Real &w3 , Real &w4 , int type );
	static void  DWeights( Real t , Real &w1 , Real& w2 , Real &w3 , Real &w4 , int type );
	static void DDWeights( Real t , Real &w1 , Real& w2 , Real &w3 , Real &w4 , int type );
};
template< class Real >
class NonUniformNonRationalBSpline
{
public:
	static Real GetWeight( Real t , int index , int d , Real* knots );
};
template< class Real >
class UniformNonRationalBSpline
{
	static Real _GetWeight( Real t , int k , int d );
public:
	static Real GetWeight( Real t , int d );
};

#include "Spline.inl"
#endif // SPLINE_INCLUDED

