/*
Copyright (c) 2011, Michael Kazhdan and Ming Chuang
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer. Redistributions in binary form must reproduce
the above copyright notice, this list of conditions and the following disclaimer
in the documentation and/or other materials provided with the distribution. 

Neither the name of the Johns Hopkins University nor the names of its contributors
may be used to endorse or promote products derived from this software without specific
prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/
#ifndef LINE_INTEGRALS_INCLUDED
#define LINE_INTEGRALS_INCLUDED
#include "Geometry.h"

// Quadrature weights obtained using Gauss-Legendre weights:
//	http://en.wikipedia.org/wiki/Gaussian_quadrature

template< int Samples >
class LineIntegrator
{
public:
	const static int SampleNum=Samples;
private:
	const static double _SamplePositionsAndWeights[];
	double _length;
	Point3D< double > _samplePositions[ Samples ];
	void _init( const Point3D< double >& p1 , const Point3D< double >& p2 );
	void _init( const Point3D< float  >& p1 , const Point3D< float  >& p2 );
public:
	double weights[ Samples ];

	LineIntegrator( void );
	LineIntegrator( const Point3D< double >& p1 , const Point3D< double >& p2 ) { _init( p1 , p2 ); }
	LineIntegrator( const Point3D< float  >& p1 , const Point3D< float  >& p2 ) { _init( p1 , p2 ); }
	LineIntegrator( const Point3D< double >* p ) { _init( p[0] , p[1] ); }
	LineIntegrator( const Point3D< float  >* p ) { _init( p[0] , p[1] ); }
	inline const Point3D< double >& operator [] ( int idx ) const;
	inline double length( void ) const;
	template< class VectorType > static VectorType Integrate( const VectorType* values );
};

typedef LineIntegrator< 1 > LineIntegrator1;
typedef LineIntegrator< 2 > LineIntegrator3;
typedef LineIntegrator< 3 > LineIntegrator5;
typedef LineIntegrator< 4 > LineIntegrator7;
typedef LineIntegrator< 5 > LineIntegrator9;

#include "LineIntegrals.inl"

#endif // LINE_INTEGRALS_INCLUDED
