/*
Copyright (c) 2011, Michael Kazhdan and Ming Chuang
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer. Redistributions in binary form must reproduce
the above copyright notice, this list of conditions and the following disclaimer
in the documentation and/or other materials provided with the distribution. 

Neither the name of the Johns Hopkins University nor the names of its contributors
may be used to endorse or promote products derived from this software without specific
prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

template< class VertexData , class EdgeData , class FaceData >
std::vector< int > HalfEdgeInterface< VertexData , EdgeData , FaceData >::VertexAdjacentVertices
(
 const std::vector< Vertex< VertexData > >& vertices ,
 const std::vector< Edge< EdgeData > >& edges ,
 const std::vector< Face< FaceData > >& faces ,
 int vIndex
)
{
	std::vector< int > adj;
	int startEdge = vertices[vIndex].edgePointer;
	int currentEdge = startEdge;
	do
	{
		adj.push_back( edges[currentEdge].startVertexPointer );
		currentEdge = edges[ edges[currentEdge].nextEdgePointer ].oppositeEdgePointer;
	}
	while( currentEdge!=startEdge && currentEdge!=-1 );
	return adj;
}
template< class VertexData , class EdgeData , class FaceData >
std::vector< int > HalfEdgeInterface< VertexData , EdgeData , FaceData >::VertexAdjacentFaces
(
 const std::vector< Vertex< VertexData > >& vertices ,
 const std::vector< Edge< EdgeData > >& edges ,
 const std::vector< Face< FaceData > >& faces ,
 int vIndex
)
{
	std::vector< int > adj;
	int startEdge = vertices[vIndex].edgePointer;
	int currentEdge = startEdge;
	do
	{
		adj.push_back( edges[currentEdge].facePointer );
		currentEdge = edges[ edges[currentEdge].nextEdgePointer ].oppositeEdgePointer;
	}
	while( currentEdge!=startEdge && currentEdge!=-1 );
	return adj;
}
template< class VertexData , class EdgeData , class FaceData >
std::vector< int > HalfEdgeInterface< VertexData , EdgeData , FaceData >::VertexAdjacentEdges
(
 const std::vector< Vertex< VertexData > >& vertices ,
 const std::vector< Edge< EdgeData > >& edges ,
 const std::vector< Face< FaceData > >& faces ,
 int vIndex
)
{
	std::vector< int > adj;
	int startEdge = vertices[vIndex].edgePointer;
	int currentEdge = startEdge;
	do
	{
		adj.push_back( currentEdge );
		currentEdge = edges[ edges[currentEdge].nextEdgePointer ].oppositeEdgePointer;
	}
	while( currentEdge!=startEdge && currentEdge!=-1 );
	return adj;
}

template< class VertexData , class EdgeData , class FaceData >
std::vector< int > HalfEdgeInterface< VertexData , EdgeData , FaceData >::FaceVertices
(
 const std::vector< Vertex< VertexData > >& vertices ,
 const std::vector< Edge< EdgeData > >& edges ,
 const std::vector< Face< FaceData > >& faces ,
 int fIndex
)
{
	std::vector< int > adj;
	int startEdge = faces[fIndex].edgePointer;
	int currentEdge = startEdge;
	do
	{
		adj.push_back( edges[currentEdge].startVertexPointer );
		currentEdge = edges[currentEdge].nextEdgePointer;
	}
	while( currentEdge!=startEdge );
	return adj;
}
template< class VertexData , class EdgeData , class FaceData >
std::vector< int > HalfEdgeInterface< VertexData , EdgeData , FaceData >::FaceVertices
(
 const std::vector< Vertex< VertexData > >& vertices ,
 const std::vector< Edge< EdgeData > >& edges ,
 const std::vector< Face< FaceData > >& faces ,
 int eIndex
)
{
	std::pair< int , int > adj;
	adj.first  = edges[ eIndex ].startVertexPointer;
	adj.second = edges[ edges[eIndex].nextEdgePointer ].startVertexPointer;
	return adj;
}
