/*
Copyright (c) 2006, Michael Kazhdan and Matthew Bolitho
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer. Redistributions in binary form must reproduce
the above copyright notice, this list of conditions and the following disclaimer
in the documentation and/or other materials provided with the distribution. 

Neither the name of the Johns Hopkins University nor the names of its contributors
may be used to endorse or promote products derived from this software without specific
prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

#ifndef FUNCTION_DATA_INCLUDED
#define FUNCTION_DATA_INCLUDED
#define NEW_FUNCTION_MEMORY 1

#include "PPolynomial.h"
#if NEW_FUNCTION_MEMORY
#include "Array.h"
#endif // NEW_FUNCTION_MEMORY

template< int Degree , class Real >
class FunctionData
{
	bool primal;
	int useDotRatios;
	int normalize;
	Real start , end;
public:
	const static int D0_FLAG;
	const static int D1_FLAG;
	const static int D2_FLAG;
	const static int     DOT_FLAG;
	const static int   D_DOT_FLAG;
	const static int  D2_DOT_FLAG;
	const static int   VALUE_FLAG;
	const static int D_VALUE_FLAG;

	int depth , fCount , vCount;
#if NEW_FUNCTION_MEMORY
	Pointer( Real ) dotTable;
	Pointer( Real ) dDotTable;
	Pointer( Real ) d2DotTable;
	Pointer( Real ) valueTables;
	Pointer( Real ) dValueTables;
#else // !NEW_FUNCTION_MEMORY
	Real *dotTable,*dDotTable,*d2DotTable;
	Real *valueTables,*dValueTables;
#endif // NEW_FUNCTION_MEMORY
	PPolynomial<Degree>      baseFunction;
	PPolynomial< (Degree>0 ? Degree-1 : 0) >   dBaseFunction;
	PPolynomial< (Degree>1 ? Degree-2 : 0) >  d2BaseFunction;
#if NEW_FUNCTION_MEMORY
	Pointer( PPolynomial< Degree > ) baseFunctions;
	Pointer( PPolynomial< (Degree>0 ? Degree-1 : 0) > )  dBaseFunctions;
	Pointer( PPolynomial< (Degree>1 ? Degree-2 : 0) > ) d2BaseFunctions;
#else // !NEW_FUNCTION_MEMORY
	PPolynomial< Degree >*     baseFunctions;
	PPolynomial< (Degree>0 ? Degree-1 : 0) >*  dBaseFunctions;
	PPolynomial< (Degree>1 ? Degree-2 : 0) >* d2BaseFunctions;
#endif // NEW_FUNCTION_MEMORY

	FunctionData( void );
	~FunctionData( void );

	virtual void   setDotTables(const int& flags);
	virtual void clearDotTables(const int& flags);

	virtual void   setValueTables(const int& flags,const double& smooth=0);
	virtual void   setValueTables(const int& flags,const double& valueSmooth,const double& normalSmooth);
	virtual void clearValueTables(void);

	void set( const int& maxDepth , const PPolynomial<Degree>& F , const int& normalize , const int& useDotRatios=1 , bool symmetrize=true , int flag = D0_FLAG | D1_FLAG , bool primal=(Degree&1) , Real start=(0.) , Real end=(1.) );
	void reset( const int& maxDepth );
	Real   dotProduct(const double& center1,const double& width1,const double& center2,const double& width2) const;
	Real  dDotProduct(const double& center1,const double& width1,const double& center2,const double& width2) const;
	Real d2DotProduct(const double& center1,const double& width1,const double& center2,const double& width2) const;

	static inline int SymmetricIndex(const int& i1,const int& i2);
	static inline int SymmetricIndex(const int& i1,const int& i2,int& index);
};


#include "FunctionData.inl"
#endif // FUNCTION_DATA_INCLUDED
